package cn.com.duiba.live.conf.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.bean.conf.RegionConfBean;
import cn.com.duiba.live.conf.service.api.bean.conf.RegionConfLocationBean;
import cn.com.duiba.live.conf.service.api.dto.conf.ProvinceCityCodeDto;

import java.util.List;
import java.util.Map;

/**
 * 区域配置
 * @author lizhi
 * @date 2020/11/12 7:57 下午
 */
@AdvancedFeignClient
public interface RemoteRegionConfApiService {

    /**
     * 查询业务配置的所有省
     * @param bizId 业务ID
     * @return 省集合
     */
    @Deprecated
    List<Integer> selectProvinceCodeList(Long bizId);

    /**
     * 查询业务配置的所有省市
     * @param bizId 业务ID
     * @return 省市集合
     */
    @Deprecated
    List<RegionConfBean> findProvinceCityCodeList(Long bizId);

    /**
     * 批量查询业务配置的所有省
     * @param bizIdList 业务ID集合
     * @return key：业务ID，value：省集合
     */
    @Deprecated
    Map<Long, List<Integer>> batchSelectProvinceCodeList(List<Long> bizIdList);

    /**
     * 查询业务配置的所有省市
     * @param bizId 业务ID
     * @return 省市集合
     */
    @Deprecated
    RegionConfLocationBean packProvinceCityCode(Long bizId);

    /**
     * 批量查询业务配置的所有省市
     * @param bizIdList 业务ID集合
     * @return key：业务ID，value：省集合
     */
    @Deprecated
    Map<Long, List<ProvinceCityCodeDto>> batchFindProvinceCityCodeList(List<Long> bizIdList);

    /**
     * 批量删除、更新省市
     * @param bizId 业务Id
     * @param bizType 业务类型
     * @param provinceCityCodeList 省市代码集合
     * @return 执行结果
     * @see cn.com.duiba.live.conf.service.api.enums.conf.RegionBizTypeEnum
     */
    int batchDeleteAndInsert(Long bizId, Integer bizType, List<ProvinceCityCodeDto> provinceCityCodeList);

    /**
     * 根据业务ID和业务类型查询对应省市代码
     * @param bizId 业务ID
     * @param bizType 业务类型
     * @return 省市代码集合
     * @see cn.com.duiba.live.conf.service.api.enums.conf.RegionBizTypeEnum
     */
    List<ProvinceCityCodeDto> listProvinceCityCodeDto(Long bizId, Integer bizType);

    /**
     * 查询业务配置的所有省市
     * @param bizId 业务ID
     * @param bizType 业务类型
     * @return 省市集合
     * @see cn.com.duiba.live.conf.service.api.enums.conf.RegionBizTypeEnum
     */
    RegionConfLocationBean packProvinceCityCodeByBizIdAndType(Long bizId, Integer bizType);

}
