package cn.com.duiba.live.conf.service.api.remoteservice.pass;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.pass.LivePassQuesConfDto;
import cn.com.duiba.live.conf.service.api.param.pass.LivePassQuesConfEditParam;

import java.util.List;

/**
 * 闯关答题问题配置service
 * @author chentiecheng
 * @date 2021/6/18 1:45 下午
 */
@AdvancedFeignClient
public interface RemoteLivePassQuesConfApiService {

    /**
     * 新增配置
     * @param param 详情
     * @return 成功/失败
     */
    boolean insert(LivePassQuesConfEditParam param);

    /**
     * 编辑配置
     * @param param 详情
     * @return 成功/失败
     */
    boolean update(LivePassQuesConfEditParam param);

    /**
     * 根据id 删除问题
     * @param id 主键id
     * @return 结果
     */
    boolean deleteById(Long id);

    /**
     * 根据直播id查询问题列表
     * @param liveId 直播id
     * @return 详情
     */
    List<LivePassQuesConfDto> findByLiveId(Long liveId);

    /**
     * 根据问题id查询详情
     * @param quesId 问题id
     * @return 详情
     */
    LivePassQuesConfDto selectById(Long quesId);

}
