package cn.com.duiba.live.conf.service.api.remoteservice.pass;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.pass.LivePassQuesRedConfDto;
import cn.com.duiba.live.conf.service.api.param.pass.LivePassQuesRedEditParam;

/**
 * 闯关答题红包配置service
 * @author chentiecheng
 * @date 2021/6/18 1:45 下午
 */
@AdvancedFeignClient
public interface RemoteLivePassQuesRedConfApiService {

    /**
     * 切换开启关闭
     * @param id 配置id
     * @param openStatus 开启关闭状态
     * @see cn.com.duiba.live.conf.service.api.enums.pass.LivePassQuesConfStatusEnum
     * @return 成功/失败
     */
    boolean switchStatus(Long id,Integer openStatus);

    /**
     * 新增配置
     * @param param 详情
     * @return 成功/失败
     */
    boolean insert(LivePassQuesRedEditParam param);

    /**
     * 编辑配置
     * @param param 详情
     * @return 成功/失败
     */
    boolean update(LivePassQuesRedEditParam param);

    /**
     * 根据直播id查询配置详情
     * @param liveId 直播id
     * @return 详情
     */
    LivePassQuesRedConfDto findByLiveId(Long liveId);
}
