package cn.com.duiba.live.conf.service.api.enums.red;

import java.util.HashMap;
import java.util.Map;

/**
 * 直播红包类型
 * @author lizhi
 * @date 2020/4/2 5:07 PM
 */
public enum LiveRedPacketTypeEnum {

    START_LIVE(1, "开播红包"),
    REAL_TIME(2, "实时红包"),
    QUESTION(3, "答题红包"),
    FISSION_TREASURE(4, "裂变宝箱红包"),
    STAY_TREASURE(5, "停留宝箱红包"),
    GUESS_NUMBER(6, "猜数字红包"),
    FLIP_CARD(7, "翻牌裂变红包"),
    TIME_ROUND_RED(8, "时长轮次红包"),
    FLIP_COLLECT_WORD(10, "翻牌集字红包")
    ;

    private final Integer code;

    private final String desc;

    LiveRedPacketTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, LiveRedPacketTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (LiveRedPacketTypeEnum typeEnum : values()) {
            ENUM_MAP.put(typeEnum.getCode(), typeEnum);
        }
    }

    public static LiveRedPacketTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
