package cn.com.duiba.live.conf.service.api.enums.fortune;

import cn.com.duiba.live.conf.service.api.util.NumberUtil;
import com.google.common.collect.Maps;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Map;

/**
 * @author gxy
 * @date 2021/7/6 12:00 下午
 */
@Getter
@AllArgsConstructor
public enum FortuneRedTypeEnum {
    FIXED(1, "固定类型"),
    RANDOM(2, "随机类型"),
    ;

    private final Integer value;

    private final String desc;

    private static final Map<Integer, FortuneRedTypeEnum> ENUM_MAP = Maps.newHashMap();

    static {
        for (FortuneRedTypeEnum item : FortuneRedTypeEnum.values()) {
            ENUM_MAP.put(item.getValue(), item);
        }
    }

    /**
     * 获取对应的枚举实例
     */
    public static FortuneRedTypeEnum getEnumItem(Integer sendType) {
        if (NumberUtil.isNullOrLteZero(sendType)) {
            return null;
        }
        return ENUM_MAP.get(sendType);
    }
}
