package cn.com.duiba.live.conf.service.api.enums.pass;

import java.util.HashMap;
import java.util.Map;

/**
 * 闯关答题活动开关状态
 * @author chentiecheng
 * @date 2021/6/22 11:23 上午
 */
public enum LivePassQuesConfStatusEnum {
    CLOSE(0,"关闭"),
    OPEN(1,"开启");

    private Integer status;
    private String desc;

    LivePassQuesConfStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }
    private static final Map<Integer, LivePassQuesConfStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LivePassQuesConfStatusEnum typeEnums : values()){
            ENUM_MAP.put(typeEnums.getStatus(), typeEnums);
        }
    }

    /**
     * 根据状态获取枚举
     * @param status 状态
     * @return 状态枚举
     */
    public static LivePassQuesConfStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }
}
