package cn.com.duiba.live.conf.service.api.remoteservice.fortune;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.red.LiveConfRedPacketDto;
import cn.com.duiba.live.conf.service.api.dto.red.LiveRedPacketFortuneConfExtDto;

/**
 * @author gxy
 * @date 2021/7/6 3:02 下午
 */
@AdvancedFeignClient
public interface RemoteFortuneApiService {

    /**
     * 新增/修改好运红包配置
     *
     * @param liveConfRedPacketDto 红包基础对象信息
     * @param fortuneConfExtDto    好运红包拓展信息
     * @return 结果
     */
    Boolean saveOrUpdate(LiveConfRedPacketDto liveConfRedPacketDto, LiveRedPacketFortuneConfExtDto fortuneConfExtDto);

    /**
     * 根据红包配置id查询详情
     *
     * @param redPacketId 红包配置id
     * @return 查询结果
     */
    LiveRedPacketFortuneConfExtDto findByRedPacketId(Long redPacketId);

    /**
     * 根据直播id查询好运红包概率，存到redis60天
     *
     * @param liveId 直播id
     * @return 红包概率
     */
    Integer getProbabilityByLiveId(Long liveId);
}
