package cn.com.duiba.live.conf.service.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.red.LiveRedPacketConfExtDto;

import java.util.List;

/**
 * 直播红包配置拓展信息
 *
 * @author 吴文哲
 * @date 2021/6/11 3:01 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveRedPacketConfExtService {

    /**
     * 根据红包配置id + 配置名称 查询直播红包配置拓展信息
     *
     * @param redConfId 红包配置id
     * @param confName  红包配置名称
     * @return 红包配置拓展信息
     * @see cn.com.duiba.live.conf.service.api.enums.red.LiveRedPackConfExtEnum
     */
    LiveRedPacketConfExtDto selectByRedConfIdAndConfNameFromRedis(Long redConfId, Integer confName);

    /**
     * 根据直播间id + 配置名称 查询直播红包配置拓展信息
     *
     * @param liveId 直播间id
     * @param confName  红包配置名称
     * @return 红包配置拓展信息列表
     * @see cn.com.duiba.live.conf.service.api.enums.red.LiveRedPackConfExtEnum
     */
    List<LiveRedPacketConfExtDto> selectByLiveIdAndConfName(Long liveId, Integer confName);

    /**
     * 新增/修改
     * @param confExtDto 配置信息
     * @return 影响行数
     */
    int saveConfExt(LiveRedPacketConfExtDto confExtDto);
}
