package cn.com.duiba.live.conf.service.api.dto.pass;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 闯关答题红包活动配置基础信息redis dto
 * @author chentiecheng
 * @date 2021-06-18
 */
@Data
public class LivePassQuesBaseConfRedisDto implements Serializable {

    private static final long serialVersionUID = -5201095151546176043L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 0:关闭,1:开启
     * @see cn.com.duiba.live.conf.service.api.enums.pass.LivePassQuesConfStatusEnum
     */
    private Integer confStatus;

    /**
     * 红包状态
     * @see cn.com.duiba.live.conf.service.api.enums.pass.LivePassRedStatusEnum
     */
    private Integer rewardStatus;
    /**
     * 红包上架时间
     */
    private Date redShelfTime;

    /**
     * 瓜分倒计时
     */
    private Integer carveTime;

    /**
     * 红包:tb_live_conf_red_packet.id
     */
    private Long redPacketId;
}