package cn.com.duiba.live.conf.service.api.dto.potential;

import cn.com.duiba.live.conf.service.api.dto.common.CommonQuestionDto;
import cn.com.duiba.live.conf.service.api.enums.potential.AgentDirectlyEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 客户管理话术
 *
 * @author ZhangJun
 * @date 2021/8/19 11:19 上午
 */
@Data
public class LivePotentialDialogueConfDto implements Serializable {

    private static final long serialVersionUID = -2768086725167403353L;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 人脉类型，1-一度人脉，0-多度人脉
     * @see AgentDirectlyEnum
     */
    private Integer inviteType;

    /**
     * 代理人欢迎语
     */
    private String agentGreet;

    /**
     * 推荐问题列表
     */
    private List<CommonQuestionDto> quesList;

    /**
     * 承诺卡片标题
     */
    private String promiseTitle;

    /**
     * 承诺卡片描述
     */
    private String promiseDesc;

    /**
     * 承诺卡片按钮文案
     */
    private String promiseButton;

    /**
     * 客户行动承诺
     */
    private String customerActionPromise;

    /**
     * 代理人结束语
     */
    private String agentConclusion;

}
