package cn.com.duiba.live.conf.service.api.enums.popup;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-07-26 11:58
 * 直播授权弹窗场景
 */
@Getter
@AllArgsConstructor
public enum LiveAuthPopupSceneEnum {

    /**
     * 每加一种授权弹窗类型，需要添加对应的apollo配置
     * @see cn.com.duiba.live.conf.service.config.LiveAuthPopupConfig
     */

    LIVE_LOTTERY(1, "直播抽奖"),
    FISSION_TREASURE(2, "裂变宝箱"),
    FLIP_WORD(3, "翻牌集字"),
    LUCKY_RED(4, "手气王红包"),
    GUESS_RED(5, "猜数红包"),
    FORTUNE_RED(6, "好运红包"),
    QUESTION_RED(7, "闯关答题"),
    DEGREE_NO_LOTTERY(8, "降级无抽奖");

    /**
     * 场景
     */
    private final Integer scene;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 场景值集合
     */
    private static final Map<Integer, LiveAuthPopupSceneEnum> SCENE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(LiveAuthPopupSceneEnum::getScene, Function.identity(), (v1, v2) -> v1)));

    /**
     * 判断是否包含场景值
     */
    public static LiveAuthPopupSceneEnum getByScene(Integer scene){
        if(Objects.isNull(scene)){
            return null;
        }
        return SCENE_MAP.get(scene);
    }
}
