package cn.com.duiba.live.conf.service.api.enums.treasure;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 宝箱配置状态枚举
 * @author 吴文哲
 * @date 2021/4/8 2:42 下午
 **/
@Getter
@AllArgsConstructor
public enum TreasureConfStatusEnum {

    /**
     * 宝箱开启状态
     */
    CLOSED(0,"关闭"),
    ENABLE(1,"开启"),
    ;

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;

    private static final List<Integer> STATUS_LIST = new ArrayList<>();

    static {
        for (TreasureConfStatusEnum statusEnum :values()){
            STATUS_LIST.add(statusEnum.getStatus());
        }
    }

    public static boolean contains(Integer status) {
        if (Objects.isNull(status)) {
            return false;
        }
        return STATUS_LIST.contains(status);
    }

}
