package cn.com.duiba.live.conf.service.api.remoteservice.evaluation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.evaluation.EvaluationConfDetailDto;
import cn.com.duiba.live.conf.service.api.dto.evaluation.EvaluationConfDto;
import cn.com.duiba.live.conf.service.api.dto.evaluation.EvaluationSimpleDto;
import cn.com.duiba.live.conf.service.api.enums.evaluation.EvaluationStatusEnum;
import cn.com.duiba.live.conf.service.api.param.common.PageQuery;

import java.util.List;

/**
 * 测试配置rpc
 *
 * @author xuzhigang
 * @date 2021/8/26 1:44 下午
 **/
@AdvancedFeignClient
public interface RemoteEvaluationConfService {
    /**
     * 分页查询 管理后台专用
     *
     * @param companyId 公司
     * @param pageQuery 分页参数
     * @return 列表
     */
    List<EvaluationConfDto> selectPage(Long companyId, PageQuery pageQuery);

    /**
     * count 管理后台专用
     *
     * @param companyId 公司id
     * @return 数量
     */
    Long selectCount(Long companyId);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播中测试配置
     */
    EvaluationConfDto selectById(Long id);

    /**
     * 根据id集合批量查询
     *
     * @param ids id集合
     * @return 配置列表
     */
    List<EvaluationConfDto> selectByIds(List<Long> ids);

    /**
     * 新增/编辑
     *
     * @param dto 测试数据
     * @return true-成功 false-失败
     */
    boolean saveOrUpdate(EvaluationConfDetailDto dto);

    /**
     * 更新启用过的配置
     * 只会更新文本信息
     *
     * @param dto 测评配置
     * @return true-更新成功 false-更新失败
     */
    boolean updateEnabled(EvaluationConfDetailDto dto);

    /**
     * 根据id查询详情 管理后台用
     *
     * @param id 测试主键id
     * @return 测试详情
     */
    EvaluationConfDetailDto findDetailById(Long id);

    /**
     * 根据id查询详情 redis缓存 web端用
     *
     * @param id 测试主键id
     * @return 测试详情
     */
    EvaluationConfDetailDto findDetailByIdWithCache(Long id);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 更新状态
     *
     * @param id 主键
     * @param status {@link EvaluationStatusEnum}
     * @return 执行结果
     */
    int updateStatus(Long id, Integer status);

    /**
     * 根据测评配置标题查询，最多返回200条
     * @param evaluationTitle 测评标题
     * @return 测评信息
     */
    List<EvaluationSimpleDto> searchByTitle(String evaluationTitle);
}
