package cn.com.duiba.live.conf.service.api.dto.flip.word;

import lombok.Data;
import java.io.Serializable;

/**
 * 翻牌集字配置表
 * @author kjj mybatis generator 
 * @date 2021-07-01
 */
@Data
public class LiveFlipWordConfDto implements Serializable {
     
    private static final long serialVersionUID = 16251268314666767L;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 展示金额
     */
    private Integer showAmount;

    /**
     * 最大可得金额（展示）
     */
    private Integer showMaxAmount;

    /**
     * 奖池模式类型
     * @see cn.com.duiba.live.conf.service.api.enums.BooleanEnum
     */
    private Integer poolType;

    /**
     * 免费次数
     */
    private Integer freeNum;

    /**
     * 需要助力人数
     */
    private Integer helpNum;

    /**
     * 单个红包金额
     */
    private Integer amount;

    /**
     * 红包个数
     */
    private Integer num;

    /**
     * 配置状态，1=未开启，2=已开启，3=已下架
     * {@link cn.com.duiba.live.conf.service.api.enums.flip.word.FlipWordConfStatusEnum}
     */
    private Integer openStatus;

    /**
     * 红包id
     */
    private Long redConfId;

}