package cn.com.duiba.live.conf.service.api.enums.conf;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * 直播状态
 * @author 吴文哲
 * @date 2020-04-02 20:37
 **/
public enum InteractStatusEnums {

    NOT_START(0,"未开始"),
    NOT_OPEN(1,"已删除"),
    IN_USE(2,"已上架"),
    NOT_IN_USE(3,"已下架"),
    ;

    /**
     * 状态
     */
    private Integer status;

    /**
     * 描述
     */
    private String desc;

    InteractStatusEnums(Integer status, String desc){
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static List<Integer> notDeleteStatusList = Lists.newArrayList();

    static {
        notDeleteStatusList.addAll(Lists.newArrayList(NOT_START.getStatus(), IN_USE.getStatus(), NOT_IN_USE.getStatus()));
    }
}
