package cn.com.duiba.live.conf.service.api.enums.popup;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-07-26 11:58
 * 直播授权弹窗场景
 */
@Getter
@AllArgsConstructor
public enum LiveAuthPopupSceneEnum {

    /**
     * 每加一种授权弹窗类型，需要添加对应的apollo配置
     * @see cn.com.duiba.live.conf.service.config.LiveAuthPopupConfig
     */

    LIVE_LOTTERY(1, "直播抽奖"),
    FISSION_TREASURE(2, "裂变宝箱"),
    FLIP_WORD(3, "翻牌集字"),
    LUCKY_RED(4, "手气王红包"),
    GUESS_RED(5, "猜数红包"),
    FORTUNE_RED(6, "好运红包"),
    QUESTION_RED(7, "闯关答题"),
    DEGREE_NO_LOTTERY(8, "降级无抽奖");

    /**
     * 场景
     */
    private final Integer scene;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 场景值集合
     */
    private static final Set<Integer> SCENE_SET = Collections.unmodifiableSet(Arrays.stream(values()).map(LiveAuthPopupSceneEnum::getScene).collect(Collectors.toSet()));

    /**
     * 判断是否包含场景值
     */
    public static boolean contains(Integer scene){
        if(Objects.isNull(scene)){
            return false;
        }
        return SCENE_SET.contains(scene);
    }
}
