package cn.com.duiba.live.conf.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.conf.LiveActionScoreConfDto;

import java.util.List;

/**
 * 直播行为得分配置rpc接口
 * @author 吴文哲
 * @date 2020-09-22 14:04
 **/
@AdvancedFeignClient
public interface RemoteLiveActionScoreConfApiService {

    /**
     * 查询所有配置信息
     * @return 直播行为得分配置列表
     */
    List<LiveActionScoreConfDto> getAllConfigList();

    /**
     * 查询所有配置信息的id列表
     * @return 直播行为得分配置信息的id列表
     */
    List<Long> getAllConfigIdList();


    /**
     * 批量插入 直播行为得分配置信息列表
     * @param addList 待插入的列表
     * @return 影响行数
     */
    int batchInsert(List<LiveActionScoreConfDto> addList);

    /**
     * 批量修改 直播行为得分配置信息列表
     * @param updateList 待修改的列表
     * @return 影响行数
     */
    int batchUpdate(List<LiveActionScoreConfDto> updateList);
}
