package cn.com.duiba.live.conf.service.api.remoteservice.round;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.round.LiveTimeRedReceiveNumDto;
import cn.com.duiba.live.conf.service.api.dto.round.LiveTimeRedRoundDto;
import cn.com.duiba.live.conf.service.api.param.common.PageQuery;
import java.util.List;

/**
 * @author guoxuebiao
 * @date 2021/6/10 11:41 上午
 */
@AdvancedFeignClient
public interface RemoteLiveTimeRedRoundApiService {

    /**
     * 保存更新轮次红包
     * @param dto 保存更新dto
     * @return 保存操作返回红包id， 更新则返回成功操作的条数
     */
    long saveOrUpdateLiveTimeRedRound(LiveTimeRedRoundDto dto);

    /**
     * 分页查询轮次红包
     * @param pageQuery 分页参数
     * @param liveId 直播id
     * @return 轮次红包列表
     */
    List<LiveTimeRedRoundDto> findPage(PageQuery pageQuery, Long liveId);

    /**
     * 从缓存中查询轮次红包列表
     * @param liveId 直播id
     * @return 轮次红包列表
     */
    List<LiveTimeRedRoundDto> findPageWithCache(Long liveId);

    /**
     * 根据直播id查询轮次红包个数
     * @param liveId 直播id
     * @return 轮次红包个数
     */
    int findCount(Long liveId);

    /**
     * 根据红包轮次id删除轮次红包
     * @param id 红包轮次id
     * @return 成功操作的条数
     */
    int delete(Long id);

    /**
     * 根据id查看红包轮次详情
     * @param id 红包轮次id
     * @return 红包轮次详情
     */
    LiveTimeRedRoundDto selectById(Long id);

    /**
     * 保存更新领取人数
     * @param dto 参数
     * @return 成功操作的条数
     */
    int saveUpdateReceiveNum(LiveTimeRedReceiveNumDto dto);

    /**
     * 打开/关闭时长轮次红包
     * @param liveId 直播id
     * @param confStatus {@link cn.com.duiba.live.conf.service.api.enums.common.CommonConfigSwitchEnum}
     * @return 是否成功
     */
    boolean switchStatus(Long liveId, Integer confStatus);

    /**
     * 根据直播id查询最小的时长轮次红包id
     * @param liveId 直播id
     * @return 时长轮次红包id
     */
    Long findMinId(Long liveId);
}
