package cn.com.duiba.live.conf.service.api.remoteservice.survey;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.survey.LiveSurveyDto;

/**
 * 直播问卷配置
 * @author kjj mybatis generator 
 * @date 2021-02-02
 */
@AdvancedFeignClient
public interface RemoteLiveSurveyService {

    /**
     * 根据直播id查询
     * @param liveId 直播id
     * @return 直播问卷配置
     */
    LiveSurveyDto selectByLiveId(Long liveId);

    /**
     * 根据直播id删除
     * @param liveId 直播id
     * @return 直播问卷配置
     */
    int deleteByLiveId(Long liveId);

    /**
     * 新增
     * @param dto 直播问卷配置
     * @return 执行结果
     */
    int saveOrUpdate(LiveSurveyDto dto);
}