package cn.com.duiba.live.conf.service.api.enums.red;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2021/08/30 10:44
 * @description 直播红包发放类型枚举
 */
@Getter
@AllArgsConstructor
public enum LiveRedSendTypeEnum {

    RANDOM(1, "随机金额"),
    FIXED(2, "固定金额"),
    ;

    private static final Map<Integer, LiveRedSendTypeEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(LiveRedSendTypeEnum::getType, Function.identity()))
    );

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 根据类型获取枚举
     */
    public static LiveRedSendTypeEnum getByType(Integer type) {
        return ENUM_MAP.get(type);
    }
}
