package cn.com.duiba.live.conf.service.api.dto.pass;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 闯关答题红包配置表
 * @author kjj mybatis generator 
 * @date 2021-06-18
 */
@Data
public class LivePassQuesRedConfDto implements Serializable {
     
    private static final long serialVersionUID = 16239950283462510L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 0:关闭,1:开启
     * @see cn.com.duiba.live.conf.service.api.enums.pass.LivePassQuesConfStatusEnum
     */
    private Integer confStatus;

    /**
     * 红包状态
     * @see cn.com.duiba.live.conf.service.api.enums.pass.LivePassRedStatusEnum
     */
    private Integer rewardStatus;
    /**
     * 红包上架时间
     */
    private Date redShelfTime;

    /**
     * 瓜分倒计时
     */
    private Integer carveTime;

    /**
     * 红包:tb_live_conf_red_packet.id
     */
    private Long redPacketId;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer logicDeleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}