package cn.com.duiba.live.conf.service.api.enums.pub.form;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2021/09/29 16:20
 * @description 公域流量 - 表单测试 状态枚举
 */
@Getter
@AllArgsConstructor
public enum PubFormStatusEnum {

    CLOSED(1, "关闭"),
    OPENED(2, "开启"),
    OFF_SHELF(3, "下架"),
    ;

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, PubFormStatusEnum> ENUM_MAP = Arrays.stream(PubFormStatusEnum.values()).collect(
            Collectors.toMap(PubFormStatusEnum::getStatus, Function.identity()));

    /**
     * 根据状态获取对应枚举, 如果为空则表示枚举值错误
     * @param status 枚举值
     * @return 枚举类
     */
    public static PubFormStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

}
