package cn.com.duiba.live.conf.service.api.remoteservice.flip.step;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.flip.step.LiveFlipWordStepConfDto;

import java.util.Map;

/**
 * 翻牌集字-阶梯红包
 *
 * @author ZhangJun
 * @date 2021/9/8 3:00 下午
 */
@AdvancedFeignClient
public interface RemoteLiveFlipWordStepService {

    /**
     * <h3>保存/更新翻牌集字配置</h3>
     * <pre>
     *       live-conf-service                            clue-center、liveweb
     *       1.参数校验，操作合法性校验
     *          1.1 是否允许修改操作
     *          1.2 总红包数量是否超出限制范围
     *       2.保存/更新DB
     *          2.1 红包
     *          2.2 免费次数
     *          2.3 标题配图
     *       3.更新缓存
     *          3.1 redis红包库存
     *          3.2 集字配置redis缓存
     *          3.3 MQ广播清除集字配置本地缓存 -------MQ广播------> 清除集字本地缓存
     *    </pre>
     *
     * @param dto 配置详情
     * @return 保存/更新结果
     */
    boolean saveOrUpdate(LiveFlipWordStepConfDto dto);

    /**
     * 删除指定翻牌阶梯红包
     * <ol>
     *     <li>删DB红包</li>
     *     <li>删redis红包库存</li>
     *     <li>删redis集字配置</li>
     *     <li>MQ广播删本地缓存</li>
     * </ol>
     *
     * @param liveId    直播id
     * @param redConfId 红包id
     * @return 删除结果
     */
    boolean deleteStepRed(Long liveId, Long redConfId);

    /**
     * 根据直播id获取翻牌集字配置详情
     * Redis(1天) -> DB
     *
     * @param liveId 直播Id
     * @return 配置详情
     */
    LiveFlipWordStepConfDto getFlipWordDetail(Long liveId);

    /**
     * 切换配置状态
     * 未开启 --> 已开启 <--->已下架
     *
     * @param liveId 直播Id
     * @param status 状态 {@link cn.com.duiba.live.conf.service.api.enums.flip.word.FlipWordConfStatusEnum}
     * @return 执行结果
     */
    boolean switchStatus(Long liveId, Integer status);

    /**
     * 根据直播id获取翻牌集字红包领取人数
     * 一次DB，不走redis，会存在延迟
     *
     * @param liveId 直播Id
     * @return 红包领取人数，key：redConfId，value：已领取人数
     */
    Map<Long, Integer> getFlipWordReceiveNum(Long liveId);

}
