package cn.com.duiba.live.conf.service.api.remoteservice.pub.form;

import cn.com.duiba.live.conf.service.api.dto.pub.form.PubFormConfDto;
import cn.com.duiba.live.conf.service.api.param.common.PageQuery;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2021/09/29 16:20
 * @description 公域流量 - 表单测试 RPC Service
 */
public interface RemotePubFormConfApiService {

    /**
     * 分页查询列表 ( 管理后台专用 )
     *
     * @param pageQuery 分页参数
     * @return 测试列表
     */
    List<PubFormConfDto> selectPage(PageQuery pageQuery);

    /**
     * 查询记录的总记录数 ( 管理后台专用 )
     *
     * @return 总记录数
     */
    Long selectCount();

    /**
     * 获取表单配置详情 Redis -> DB
     *
     * @param id 表单Id
     * @return 配置详情
     */
    PubFormConfDto findByIdWithCache(Long id);

    /**
     * 新增/更新配置
     *
     * @param confDto 公域流量 - 表单测试配置
     * @return 表单Id
     */
    boolean saveOrUpdate(PubFormConfDto confDto);

    /**
     * 逻辑删除
     *
     * @param id 表单Id
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 更新表单状态
     *
     * @param id     表单Id
     * @param status 目标状态
     *               {@link cn.com.duiba.live.conf.service.api.enums.pub.form.PubFormStatusEnum}
     * @return 执行结果
     */
    int updateStatus(Long id, Integer status);

}
