package cn.com.duiba.live.conf.service.api.dto.second.kill;

import lombok.Data;

import java.io.Serializable;

/**
 * @author guoxuebiao
 * @date 2021/8/6 3:21 下午
 */
@Data
public class LiveSecondKillGoodsSaveDto implements Serializable {

    private static final long serialVersionUID = -3193022801634623370L;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * 秒杀价格
     */
    private Integer goodsAmount;

    /**
     * 商品数量
     */
    private Integer interactNum;

    /**
     * 代理人能否参加 0-否 1-是
     * {@link cn.com.duiba.live.conf.service.api.enums.BooleanEnum}
     */
    private Integer ableAgent;

    /**
     * 是否需要秒杀资格 0-否 1-是
     * {@link cn.com.duiba.live.conf.service.api.enums.BooleanEnum}
     */
    private Integer isNeedQualified;

    /**
     * 秒杀资格直播助力人数
     */
    private Integer assistPeopleNum;

    /**
     * 秒杀资格抽卡必中配置
     */
    private LiveSecondKillCardConfigDto infallibleConfig;

    /**
     * 秒杀资格抽卡配置1
     */
    private LiveSecondKillCardConfigDto cardConfigOne;

    /**
     * 秒杀资格抽卡配置2
     */
    private LiveSecondKillCardConfigDto cardConfigTwo;

    /**
     * 秒杀资格助力限制
     */
    private Integer assistLimit;

}
