package cn.com.duiba.live.conf.service.api.enums;

/**
 * @author lizhi
 * @date 2020/3/30 2:34 PM
 */
public enum RedisKeyFactory {

    KC001("直播详情缓存"),
    KC002("直播推流缓存"),
    KC003("直播拉流缓存"),
    KC004("直播缓存"),
    KC005("直播开播红包缓存"),
    KC006("直播实时红包缓存"),
    KC007("直播红包缓存"),
    KC008("直播随机红包队列缓存"),
    KC010("直播新增或修改红包 分布式锁"),
    KC011("直播助力人数"),
    KC012("保存直播推送信息 分布式锁"),

    KC014("根据代理人id获取公司id缓存"),
    KC015("根据用户id获取公司id缓存"),
    KC016("直播间访客纬度统计锁"),
    KC017("直播间纬度统计锁"),
    KC018("用户当前直播间邀请人数缓存"),
    KC019("用户累计观看当前直播间时长缓存"),
    KC020("用户关注直播间缓存"),
    KC021("绑定关系建立锁"),
    KC022("新增代理人统计记录"),
    KC023("新增团队统计记录"),
    KC024("新增访客访问记录锁"),

    KC025("直播间被禁言的用户列表"),
    KC026("直播间在线人数统计"),
    KC027("直播间观看人数统计"),
    KC028("直播间评论人数统计"),
    KC029("直播间分享人数"),

    KC030("领取权益"),
    KC031("根据userId查询代理人缓存"),
    KC032("公司代理人map 缓存"),
    KC033("刷新公司代理人map缓存 分布式锁"),

    KC034("直播红包redis队列分布式锁"),
    KC035("直播用户ID缓存"),
    KC036("直播用户的邀请代理人ID缓存"),

    KC037("直播间来了缓存"),
    KC038("直播讲解中"),
    KC039("直播历史提问"),
    KC040("直播最近提问"),

    KC041("阿里云app缓存"),

    KC042("黑名单源头用户信息缓存"),

    KC045("直播红包更改为结束，分布式锁"),
    KC046("普通红包中奖凭证，缓存"),
    KC047("手气王红包中奖凭证，缓存"),
    KC048("普通红包中奖人员，缓存"),
    KC049("手气红包王中奖人员，缓存"),
    KC050("领红包结果-废弃，缓存"),
    KC051("领红包结果新，缓存"),

    KC052("公司线索员的缓存"),

    KC053("美颜配置新增或修改 分布式锁"),
    KC054("直播推送失败告警阈值推送"),
    KC055("公司线索员的缓存-新"),

    KC060("分享直播间推送 队列缓存"),
    KC061("领取福利推送 队列缓存"),

    KC062("上架中推送 缓存"),
    KC065("访客预约直播间,用于taskCenter推送的缓存,否则db压力过大"),

    KC069("直播间给所有用户固定限流推送缓存"),
    KC070("直播间给所有用户通用推送缓存"),
    KC071("直播间给指定用户通用推送缓存"),
    KC072("弹幕队列"),
    KC073("弹幕裁剪锁"),
    KC074("已提交表单记录缓存"),
    KC075("回收成功案例新增或修改 分布式锁"),
    KC076("主推资料贴片缓存"),

    KC079("抽奖奖池，分布式锁"),
    KC080("权益待抽奖队列，分布式锁"),
    KC081("权益待抽奖队列，缓存"),
    KC082("权益出奖，分布式锁"),
    KC083("权益出奖中奖人数，缓存"),
    KC084("权益出奖真实中奖人员，缓存"),
    KC085("权益出奖中奖列表，缓存"),
    KC089("权益状态更改，分布式锁"),

    KC090("红包是否需要入池，缓存"),
    KC091("红包入池，分布式锁"),
    KC092("红包入池队列，缓存"),
    KC093("红包出奖，分布式锁"),
    KC094("红包领取结果列表，缓存"),
    KC095("红包每个ip领取数量，缓存"),
    KC096("红包ip限制，分布式锁"),
    KC097("权益出奖中奖昵称列表，缓存"),
    KC098("绑定小程序码，分布式锁"),
    KC099("访客小程序码, 缓存"),

    KC100("直播在不同平台的拉流缓存"),

    KC101("公司缓存"),
    KC102("直播代理人指定中奖配置记录缓存"),
    KC103("引导视频-访客记录新增 分布式锁"),
    KC104("引导视频新增 分布式锁"),

    KC105("直播团队平均邀请/到场统计频次缓存"),
    KC106("直播id+红包类型缓存"),
    KC107("红包配置缓存"),
    KC108("红包配置拓展信息缓存"),
    KC109("互动配置拓展信息缓存"),

    KC111("答题红包随机金额预分配缓存"),
    KC112("答题红包,答错用户分享记录缓存"),
    KC117("答题红包,用户参与信息缓存"),

    KC118("定制公司团队缓存"),
    KC119("保存选项关联资料锁"),

    KC120("直播代理人公司团队关联关系-公司id维度缓存"),
    KC121("直播代理人公司团队关联关系-代理人id、公司id维度缓存"),
    KC122("直播代理人公司团队关联关系-代理人id所有的公司id缓存"),
    KC123("所有直播间访客总在线时长-redisKey"),

    KC124("直播应用缓存"),
    KC125("直播流记录缓存"),

    KC126("直播关系配置新增或修改 分布式锁"),
    KC127("直播问卷调查配置新增或修改 分布式锁"),
    KC128("免费领剩余库存-直播id、免费领配置id维度缓存"),

    KC129("测试直播间记录数据缓存"),
    KC130("奖品配送领奖人信息"),
    KC132("答题中奖对应的库存配置"),
    KC133("答题中奖的状态"),
    KC134("答题中奖配置详情缓存"),

    KC135("直播宝箱配置新增/修改锁"),
    KC136("配置Id - 宝箱配置RedisDTO缓存"),
    KC137("直播Id+场景类型 - 宝箱配置redisDTO集合缓存"),
    KC138("宝箱实物库存"),
    KC139("直播宝箱红包库存"),
    KC140("直播互动配置信息缓存"),
    KC141("宝箱相关配置列表redis缓存"),
    KC142("宝箱配置redis缓存"),

    KC143("保存或更新代理人专属链接 分布式锁"),
    KC144("抽奖团队配置总份数变更 分布式锁"),

    KC145("最新一轮猜数字红包缓存"),
    KC146("上一轮猜数红包结束时间"),
    KC147("猜数红包库存"),
    KC148("猜数红包库存分布式锁"),

    KC149("翻牌配置-直播id维度"),
    KC150("翻牌配置-id维度"),
    KC151("翻牌红包库存-基本库存"),
    KC152("翻牌红包库存-备用库存"),
    KC153("新增翻牌配置分布式锁"),

    KC154("直播宝箱-团队奖励配置列表缓存"),
    KC155("时长红包配置轮次"),
    KC156("时长轮次红包库存"),
    KC157("时长轮次红包分布式锁"),
    KC160("闯关答题活动配置缓存-直播id纬度"),
    KC161("闯关答题活动配置缓存-id纬度"),

    KC158("好运红包概率"),
    KC159("好运红包金额库存"),

    KC162("翻牌集字-集字配置"),
    KC163("翻牌集字-红包库存"),
    KC164("翻牌集字-新增/修改配置分布式锁"),

    KC166("授权弹窗配置-直播id+场景值缓存"),
    KC167("授权弹窗配置-列表缓存"),

    KC168("直播抽奖码百分比缓存"),

    KC169("秒杀商品列表redis缓存"),
    KC170("秒杀商品详情redis缓存"),
    KC171("直播秒杀-秒杀商品库存"),
    KC172("直播秒杀-秒杀商品增删改上下架分布式锁"),

    KC173("社交货币券配置-直播id维度"),
    KC174("社交货币券配置-主键id维度"),
    KC176("直播秒杀-秒杀商品上下架状态"),

    KC177("准客户话术配置分布式锁"),

    KC178("测评配置详情-主键id维度"),

    KC179("代理人邀约红包-配置更改分布式锁"),
    KC180("代理人邀约红包-配置缓存"),
    KC181("代理人邀约红包-红包列表"),

    KC182("翻牌集字阶梯红包-集字配置"),
    KC184("直播间红包redis缓存"),
    KC185("直播秒杀-最近上架的秒杀商品"),
    ;

    private static final String SPACE = "LiveConfService";
    private static final String SEPARATOR = "_";

    String desc;

    RedisKeyFactory(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }

}
