package cn.com.duiba.live.conf.service.api.remoteservice.flip.word;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.flip.word.LiveFlipWordConfDto;

/**
 * @author zhuenhui
 * @date 2021/06/30 10:11 上午
 * @description 翻牌集字 - RPC服务
 */
@AdvancedFeignClient
public interface RemoteLiveFlipWordApiService {

    /**
     * 根据直播id获取翻牌集字配置详情 (先走Redis, 再走DB)
     * @deprecated 翻牌阶梯红包上线后删除
     *
     * @param liveId 直播Id
     * @return 配置详情
     */
    @Deprecated
    LiveFlipWordConfDto getFlipWordDetail(Long liveId);

    /**
     * 切换配置状态
     * @deprecated 翻牌阶梯红包上线后删除
     *
     * @param liveId 直播Id
     * @param status 状态
     * {@link cn.com.duiba.live.conf.service.api.enums.flip.word.FlipWordConfStatusEnum}
     * @return 执行结果
     */
    @Deprecated
    boolean switchStatus(Long liveId, Integer status);

    /**
     * 保存 / 更新翻牌集字配置
     * @deprecated 翻牌阶梯红包上线后删除
     *
     * @param dto 配置详情
     * @return 执行结果
     */
    @Deprecated
    boolean saveOrUpdate(LiveFlipWordConfDto dto);

    /**
     * 根据直播id获取翻牌集字红包领取人数（两次Redis 或 一次Redis+一次DB）
     * @deprecated 翻牌阶梯红包上线后删除
     *
     * @param liveId 直播Id
     * @return 红包领取人数
     */
    @Deprecated
    Integer getFlipWordReceiveNum(Long liveId);
}
