package cn.com.duiba.live.conf.service.api.dto.livestream;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播流产生的费用统计
 * @author kjj mybatis generator
 * @date 2020-10-22
 */
@Data
public class LivestreamStatDto implements Serializable {

    private static final long serialVersionUID = 16033501515195085L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播记录ID
     */
    private Long liveId;

    /**
     * 流量总和,保留2位小数。 单位TB
     */
    private String fluxNum;

    /**
     * 转码详情
     */
    private String transcodeDetail;

    /**
     * 录制文件大小 单位：GB
     */
    private Long transcribeSize;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
