package cn.com.duiba.live.conf.service.api.dto.ques;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 有奖答题直播配置表
 * @author kjj mybatis generator 
 * @date 2021-03-23
 */
@Data
public class LiveQuesRewardConfDto implements Serializable {
     
    private static final long serialVersionUID = 16164894505159788L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 答题配置id tb_common_question.id
     */
    private Long questionId;

    /**
     * 奖品类型,1:答题送红包 2:答题送奖品
     */
    private Integer quesType;

    /**
     * 0:未发放,1:已上架,2:发放中,3:已发放
     * @see cn.com.duiba.live.conf.service.api.enums.conf.QuestionRewardStatusEnum
     */
    private Integer rewardStatus;

    /**
     * 奖品ID 红包:tb_live_conf_red_packet.id ,奖品:tb_live_interact_conf.id
     */
    private Long rewardConfId;

    /**
     * 是否删除，1=已删除，0=未删除
     * @see cn.com.duiba.live.conf.service.api.enums.DeletedEnum
     */
    private Integer logicDeleted;

    /**
     * 团队分配类型 1：未开启按团队分配 2：开启按团队分配
     * @see cn.com.duiba.live.conf.service.api.enums.conf.TeamAssignmentTypeEnum
     */
    private Integer teamAssignmentType;

    /**
     * 是否已经配置 1:未配置 2:已配置
     */
    private Integer assignmentType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}