package cn.com.duiba.live.conf.service.api.enums.clue;

import lombok.Getter;

/**
 * 直播访客行为枚举
 * @author 吴文哲
 * @date 2020-09-18 19:52
 **/
@Getter
public enum LiveVisitorActionEnums {

    READ_DURATION_FROM_0_TO_5(1,"累计观看时长0-5分钟"),
    READ_DURATION_FROM_5_TO_10(2,"累计观看时长5-10分钟"),
    READ_DURATION_FROM_10_TO_20(3,"累计观看时长10-20分钟"),
    READ_DURATION_FROM_20_TO_30(4,"累计观看时长20-30分钟"),
    READ_DURATION_OVER_30(5,"累计观看30分钟以上"),
    READ_DURATION_OVER_20(6,"累计观看20分钟以上"),
    COMMENT(11,"有评论行为"),
    SUBSCRIBE(12,"有订阅下一场直播间的行为"),
    PRESENT(13,"有预约到场行为"),
    SHARE(14,"有分享行为"),
    QUESTION(15,"有提问行为"),
    VOTE(16,"有投票行为"),
    AWARD(17,"有中奖行为"),
    FREE_AWARD(18,"有免费领福利行为"),
    RESOURCE(19,"有免费领资料行为"),
    SUBMIT(20,"有提交表单行为"),
    ADVISORY(21,"有咨询行为"),
    NEW_CUSTOMER(22,"新客户(好友邀请的客户)"),
    NOT_GET_LOTTERY(23,"本场直播未中奖"),
    NOT_WATCH(24,"本场直播未观看"),
    WATCHED(25,"观看本场直播"),
    OLD_VISITOR(26,"老客户(直接邀请)"),
    RECEIVE_TICKETS(27,"领取增员门票"),
    SPONSOR_ADD_STAFF_CONSULT(28,"发起增员咨询"),
    KILL_GOODS(29, "秒杀商品"),

    ;
    /**
     * 行为类型
     */
    private Integer action;

    /**
     * 描述
     */
    private String desc;

    LiveVisitorActionEnums(Integer action, String desc){
        this.action = action;
        this.desc = desc;
    }

}
