package cn.com.duiba.live.conf.service.api.remoteservice.card;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.card.LiveFlipCardDto;

import java.util.Map;
import java.util.Set;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-05-24 17:47
 * 翻牌红包rpc service
 */
@AdvancedFeignClient
public interface RemoteLiveFlipCardApiService {

    /**
     * 通过直播id获取翻牌配置详情
     * @param liveId 直播id
     * @return 翻牌配置详情
     */
    LiveFlipCardDto findByLiveIdFromRedis(Long liveId);

    /**
     * 通过id获取翻牌配置详情
     * @param id 配置id
     * @return 翻牌配置详情
     */
    LiveFlipCardDto findByIdFromRedis(Long id);

    /**
     * 通过id获取邀请赠送次数
     * @param ids 配置id列表
     * @return key：配置id value：邀请赠送次数
     */
    Map<Long, Integer> getInviteTime(Set<Long> ids);

    /**
     * 开启翻牌配置
     * @param liveId 直播id
     * @return 操作结果
     */
    boolean openConf(Long liveId);

    /**
     * 关闭翻牌配置
     * @param liveId 直播id
     * @return 操作结果
     */
    boolean closeConf(Long liveId);

    /**
     * 保存翻牌配置
     * @param dto 翻牌配置参数
     * @return 操作结果
     */
    boolean saveFlipCard(LiveFlipCardDto dto);

    /**
     * 编辑翻牌配置
     * @param dto 翻牌配置参数
     * @return 操作结果
     */
    boolean updateFlipCard(LiveFlipCardDto dto);
}
