package cn.com.duiba.live.conf.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.conf.LiveInteractConfExtDto;

import java.util.List;

/**
 * 直播互动配置扩展 serivece
 * @Author chentiecheng
 * @Date 2021/3/26 10:04 上午
 */
@AdvancedFeignClient
public interface RemoteLiveInteractConfExtService {
    /**
     * 根据互动id和配置查找
     *
     * @param confId 配置ID
     * @param confName 配置类型 {@link cn.com.duiba.live.conf.service.api.enums.conf.LiveInteractExtNameEnum}
     */
    LiveInteractConfExtDto selectByConfIdAndConfName(Long confId, Integer confName);

    /**
     * 从redis中 根据互动id和配置查找
     *
     * @param confId 配置ID
     * @param confName 配置类型 {@link cn.com.duiba.live.conf.service.api.enums.conf.LiveInteractExtNameEnum}
     */
    LiveInteractConfExtDto selectByConfIdAndConfNameFromRedis(Long confId, Integer confName);

    /**
     * 根据互动id列表和配置名获取扩展列表
     * @param confIds
     * @param confName {@link cn.com.duiba.live.conf.service.api.enums.conf.LiveInteractExtNameEnum}
     * @return
     */
    List<LiveInteractConfExtDto> selectListByConfIdsAndName(List<Long> confIds,Integer confName);

    /**
     *
     * 新增配置
     */
    boolean insertExt(LiveInteractConfExtDto dto);
    /**
     *
     * 修改配置
     */
    boolean updateExt(LiveInteractConfExtDto dto);


    /**
     * 删除配置
     */
    boolean deleteByConfId(Long confId);

}
