package cn.com.duiba.live.conf.service.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.red.LiveConfRedPacketCommonDto;
import cn.com.duiba.live.conf.service.api.dto.red.LiveConfRedPacketDto;
import cn.com.duiba.live.conf.service.api.dto.red.LiveConfRedPacketSaveDto;
import cn.com.duiba.live.conf.service.api.dto.red.LiveRedReceiveNumStatDto;
import cn.com.duiba.live.conf.service.api.dto.red.LiveRedUseQuotaStatDto;
import cn.com.duiba.live.conf.service.api.param.red.LiveConfRedPacketSearchParam;

import java.util.List;

/**
 * 直播红包相关
 * @author lizhi
 * @date 2020/4/3 1:33 PM
 */
@AdvancedFeignClient
public interface RemoteLiveRedPacketApiService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播配置-红包相关配置
     */
    LiveConfRedPacketDto findById(Long id);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 红包配置-不包含剩余金额/剩余数量等库存信息
     */
    LiveConfRedPacketCommonDto findCacheDtoById(Long id);

    /**
     * 根据主键批量查询
     * @param ids 主键
     * @return 直播配置-红包相关配置
     */
    List<LiveConfRedPacketDto> findByIds(List<Long> ids);

    /**
     * 根据直播间id + 红包类型查询红包列表
     * @param liveId 直播间id
     * @param redType 红包类型
     * @see cn.com.duiba.live.conf.service.api.enums.red.LiveRedPacketTypeEnum
     * @return 红包列表
     */
    List<LiveConfRedPacketDto> findByLiveIdAndRedType(Long liveId,Integer redType);

    /**
     * 根据直播间id 查询红包列表
     * @param liveId 直播间id
     * @see cn.com.duiba.live.conf.service.api.enums.red.LiveRedPacketTypeEnum
     * @return 红包列表
     */
    List<LiveConfRedPacketDto> findListByLiveId(Long liveId);

    /**
     * 根据直播间id + 红包类型查询红包列表
     * 先从redis中查询,redis中没有 再走db
     * @param liveId 直播间id
     * @param redType 红包类型
     * @see cn.com.duiba.live.conf.service.api.enums.red.LiveRedPacketTypeEnum
     * @return 红包列表-不包含剩余金额/剩余数量等库存信息
     */
    List<LiveConfRedPacketCommonDto> findCacheConfByLiveIdAndRedType(Long liveId, Integer redType);

    /**
     * 是否存在发放中的红包
     * @param liveId 直播id
     * @param status 红包状态
     * @param redTypes 红包类型
     * @return 存在结果
     */
    boolean isExistStatusRedByType(Long liveId, List<Integer> status,List<Integer> redTypes);

    /**
     * 根据直播间id查询 已发布未结束的答题红包
     * @param liveId 直播间id
     * @return 符合条件的答题红包
     */
    @Deprecated
    List<LiveConfRedPacketDto> findAvailableQuesRed(Long liveId);

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 直播配置-红包相关配置集合
     */
    @Deprecated
    List<LiveConfRedPacketDto> findList(LiveConfRedPacketSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    @Deprecated
    long findCount(LiveConfRedPacketSearchParam param);

    /**
     * 是否存在发放中的红包
     * @param liveId 直播id
     * @param status 红包状态
     * @return 存在结果
     */
    @Deprecated
    boolean isExistStatusRed(Long liveId, List<Integer> status);


    /**--------------------修改相关--------------------**/

    /**
     * 批量逻辑删除
     * @param idList 主键集合
     * @return 执行结果
     */
    int batchDelete(List<Long> idList);

    /**
     * 新增
     * @param dto 直播配置-红包相关配置
     * @return 执行结果
     */
    int insert(LiveConfRedPacketDto dto);

    /**
     * 新增
     * @param dto 直播配置-红包相关配置
     * @return 主键
     */
    @Deprecated
    Long save(LiveConfRedPacketDto dto);

    /**
     * 更新
     * @param dto 直播配置-红包相关配置
     * @return 执行结果
     */
    @Deprecated
    int update(LiveConfRedPacketDto dto);

    /**
     * 新增
     * @param dto 直播配置-红包相关配置
     * @return 主键
     */
    Long saveRedPack(LiveConfRedPacketSaveDto dto);

    /**
     * 更新
     * @param dto 直播配置-红包相关配置
     * @return 执行结果
     */
    int updateRedPack(LiveConfRedPacketSaveDto dto);

    /**
     * 更新状态
     * @param dto 直播配置-红包相关配置
     * @param expectedRedStatus 预期现有状态
     * @see cn.com.duiba.live.conf.service.api.enums.red.LiveRedPacketStatusEnum
     * @return 执行结果
     */
    int updateStatus(LiveConfRedPacketDto dto, Integer expectedRedStatus);

    /**
     * 批量扣减随机金额红包库存
     * @param id 红包配置主键
     * @param amount 领取金额
     * @param num 领取数量
     * @return 执行结果
     */
    int batchReceiveRedPacket(Long id, Integer amount, Integer num);

    /**
     * 批量扣减固定金额红包库存
     * @param id 红包配置主键
     * @param num 领取数量
     * @return 执行结果
     */
    int batchReceiveFixed(Long id, Integer num);

    /**
     * 批量扣减手气王红包库存
     * @param id 红包配置主键
     * @param num 领取数量
     * @return 执行结果
     */
    int batchReceiveLuckRedPacket(Long id, Integer num);


    /**
     * 还回红包
     * @param id 红包配置主键
     * @param amount 领取金额
     * @return 执行结果
     */
    @Deprecated
    int returnRedPacket(Long id, Integer amount);

    /**
     * 还回手气王红包
     * @param id 红包配置主键
     * @return 执行结果
     */
    @Deprecated
    int returnLuckRedPacket(Long id);


    /**
     * 根据直播id查询时长轮次红包
     * @param liveId 直播id
     * @return 时长轮次红包
     */
    LiveConfRedPacketDto findTimeRedByLiveId(Long liveId);

    /**
     * 根据直播id从缓存查询时长轮次红包
     * @param liveId 直播id
     * @return 时长轮次红包
     */
    LiveConfRedPacketCommonDto findTimeRedByLiveIdCache(Long liveId);

    /**
     * 更新
     *
     * @param id                主键
     * @param redStatus         期望状态
     * @param expectedRedStatus 现有状态
     * @return 执行结果
     */
    int updateOnlyStatusById(Long id, Integer redStatus, Integer expectedRedStatus);

    /**
     * 获取本场直播已使用的额度，查询本场直播所有红包，代码计算
     * 总金额-已结束红包的剩余金额
     * @param liveId 直播ID
     * @return 已使用的额度
     */
    LiveRedUseQuotaStatDto useQuotaByLiveId(Long liveId);

    /**
     * 计算传入的红包列表，已使用的额度
     * 总金额-已结束红包的剩余金额
     * @param liveId 直播ID，用于打印日志
     * @param list 红包列表
     * @return 已使用的额度
     */
    LiveRedUseQuotaStatDto useQuotaByList(Long liveId, List<LiveConfRedPacketDto> list);

    /**
     * 计算传入的红包列表，返回总金额,已使用金额
     * @param liveId 直播ID，用于打印日志
     * @param list 红包列表
     * @return 以发放金额
     */
    LiveRedReceiveNumStatDto redReceiveAmountByList(Long liveId, List<LiveConfRedPacketDto> list);


}
