package cn.com.duiba.live.conf.service.api.remoteservice.treasure;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.treasure.LiveTreasureConfRelatedDto;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-04-19 20:12
 * 宝箱关联表-rpc接口
 */
@AdvancedFeignClient
public interface RemoteLiveTreasureRelatedApiService {

    /**
     * 通过宝箱id列表获取宝箱关联表列表
     * @param confIds 宝箱id列表
     * @return 宝箱关联表列表
     */
    List<LiveTreasureConfRelatedDto> listByConfIds(List<Long> confIds);

    /**
     * 根据主键查询
     * @param id 主键 tb_live_treasure_conf_related.id
     * @return 直播宝箱关联配置信息
     */
    LiveTreasureConfRelatedDto selectById(Long id);

    /**
     * 根据宝箱配置id 查询 宝箱关联表信息
     *
     * @param treasureConfId 宝箱配置Id tb_live_pre_treasure_conf.id
     * @return 配置关联信息列表
     */
    List<LiveTreasureConfRelatedDto> getConfRelatedByConfId(Long treasureConfId);

}
