package cn.com.duiba.live.conf.service.api.enums.round;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

/**
 * @author guoxuebiao
 * @date 2021/6/11 6:33 下午
 */
@Getter
@AllArgsConstructor
public enum TimeRedTaskTypeEnum {


    NOT_CONFIG(0, "未配置"),
    WATCH_LIVE_ROOM(1, "关注直播间"),
    SAVE_POST(2, "保存海报"),
    RECEIVE_RESOURCE(3, "领取权益"),
    ;

    private final Integer type;
    private final String message;

    private static final Set<Integer> TYPE_LIST = new HashSet<>();

    static {
        for (TimeRedTaskTypeEnum type : values()) {
            TYPE_LIST.add(type.getType());
        }
    }

    public static boolean contains(Integer type) {
        if (Objects.isNull(type)) {
            return false;
        }
        return TYPE_LIST.contains(type);
    }
}
