package cn.com.duiba.live.conf.service.api.enums.conf;

import cn.com.duiba.live.conf.service.api.util.NumberUtil;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 直播公司扩展配置
 *
 * @author ZhangJun
 * @date 2021/8/10 7:52 下午
 */
@AllArgsConstructor
@Getter
public enum LiveCompanyExtEnum {

    /**
     * 准客户功能开关，0-关闭，1-开启
     */
    POTENTIAL_SWITCH(1, "准客户功能开关"),
    ;

    /**
     * 键，取值区间为[1,255]
     */
    private final Integer key;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, LiveCompanyExtEnum> ENUM_MAP = new HashMap<>();

    static {
        for (LiveCompanyExtEnum configEnum : values()) {
            ENUM_MAP.put(configEnum.getKey(), configEnum);
        }
    }

    /**
     * 根据key获取枚举
     *
     * @param key 键
     * @return 枚举值
     */
    public static LiveCompanyExtEnum getByType(Integer key) {
        if (NumberUtil.isNullOrLteZero(key)) {
            return null;
        }

        return ENUM_MAP.get(key);
    }

    /**
     * 是否存在该key
     *
     * @param key 需要判断的key
     * @return true=存在，false=不存在
     */
    public static boolean contains(Integer key) {
        if (NumberUtil.isNullOrLteZero(key)) {
            return false;
        }

        LiveCompanyExtEnum[] values = LiveCompanyExtEnum.values();
        for (LiveCompanyExtEnum item : values) {
            if (Objects.equals(item.getKey(), key)) {
                return true;
            }
        }

        return false;
    }

    /**
     * 获取直播公司配置key集合
     *
     * @return 配置key集合
     */
    public static List<Integer> allKeys() {
        return Lists.newArrayList(ENUM_MAP.keySet());
    }
}
