package cn.com.duiba.live.conf.service.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.company.LiveCompanyExtDto;

import java.util.List;
import java.util.Map;

/**
 * 直播公司扩展配置服务
 *
 * @author ZhangJun
 * @date 2021/8/10 7:49 下午
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyExtApiService {

    /**
     * 新增/修改直播公司配置
     * 没有就新增 存在就修改
     * @param extDto 直播公司配置对象
     * @return 保存结果
     */
    boolean saveLiveCompanyConfig(LiveCompanyExtDto extDto);

    /**
     * 批量新增或更新
     * @param extDtos 拓展配置集合
     * @return 执行结果
     */
    boolean batchInsertOrUpdate(List<LiveCompanyExtDto> extDtos);

    /**
     * 根据直播公司id+配置名，获取直播公司配置
     * @param companyId 直播公司id
     * @param confName 配置名称
     * @see cn.com.duiba.live.conf.service.api.enums.conf.LiveCompanyExtEnum
     * @return 直播间配置
     */
    LiveCompanyExtDto getLiveCompanyExtByCompanyIdAndConfName(Long companyId,Integer confName);

    /**
     * 批量获取直播间配置
     * @param companyIds 直播公司id集合
     * @param confName 配置名称
     * @see cn.com.duiba.live.conf.service.api.enums.conf.LiveCompanyExtEnum
     * @return key:companyId val:confVal
     */
    Map<Long,String> getConfValuesByLiveCompanyIds(List<Long> companyIds,Integer confName);

}
