package cn.com.duiba.live.conf.service.api.remoteservice.provider;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.provider.LiveConfPrizeProviderBizDto;
import cn.com.duiba.live.conf.service.api.dto.provider.LiveConfPrizeProviderDto;

import java.util.List;
import java.util.Map;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-03-22 19:56
 * 奖品配送-奖品发放人rpc-service
 */
@AdvancedFeignClient
public interface RemotePrizeProviderApiService {

    /**
     * 查询已经存在的业务ID
     * @param liveId 直播ID
     * @param bizType 单位类型
     * @see cn.com.duiba.live.conf.service.api.enums.provider.LiveProviderBizTypeEnum
     * @param bizIds 业务ID集合
     * @return bizId，id
     */
    List<LiveConfPrizeProviderBizDto> findExistBiz(Long liveId, Integer bizType, List<Long> bizIds);

    /**
     * 通过直播id+业务类型获取主键
     * @param liveId 直播id
     * @param bizType 业务类型
     * @return 主键
     */
    Long getMaxBizId(Long liveId, Integer bizType);

    /**
     * 根据直播id+单位类型+业务id获取发奖人信息
     * @param liveId 直播id
     * @param bizType 单位类型
     * @param bizId 业务id
     * @return 发奖人信息
     */
    LiveConfPrizeProviderDto getByCondition(Long liveId, Integer bizType, Long bizId);

    /**
     * 批量插入
     * @param param 发奖人信息
     */
    void batchInsert(List<LiveConfPrizeProviderDto> param);

    /**
     * 批量更新
     * @param param 发奖人信息
     */
    void batchUpdate(List<LiveConfPrizeProviderDto> param);
}
