package cn.com.duiba.live.conf.service.api.dto.second.kill;

import lombok.Data;

/**
 * 秒杀商品信息
 *
 * @author guoxuebiao
 * @date 2021/8/10 8:40 下午
 */
@Data
public class LiveSecondKillGoodsDto {

    /**
     * 秒杀商品id/配置id, tb_live_interact_conf.id
     */
    private Long id;

    /**
     * 秒杀商品
     */
    private String goodsTitle;

    /**
     * 商品图片
     */
    private String goodsImg;

    /**
     * 秒杀价格
     */
    private Integer goodsAmount;

    /**
     * 商品数量
     */
    private Integer interactNum;

    /**
     * 商品状态 0-未上架，1-已删除，2-已上架，3-已下架，
     * @see cn.com.duiba.live.conf.service.api.enums.conf.InteractStatusEnums
     */
    private Integer interactStatus;

    /**
     * 剩余数量
     */
    private Integer surplusNum;

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * 代理人能否参加，0-否 1-是
     */
    private Integer ableAgent;
}
