package cn.com.duiba.live.conf.service.api.dto.treasure.redis;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhuenhui
 * @date 2021/04/16 8:35 下午
 * @description 直播宝箱Redis缓存
 */
@Data
public class LiveTreasureRedisDto implements Serializable {

    private static final long serialVersionUID = -7705061205366571932L;

    /**
     * 主键id tb_live_pre_treasure_conf.id
     */
    private Long treasureConfId;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 宝箱场景(业务维度) 1:直播前宝箱 2:直播中宝箱
     *
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureSceneTypeEnum
     */
    private Integer treasureScene;

    /**
     * 宝箱排序，默认为1
     */
    private Integer treasureSort;

    /**
     * 宝箱周期
     *
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasurePeriodTypeEnum
     */
    private Integer treasurePeriod;

    /**
     * 0:关闭,1:开启
     *
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureConfStatusEnum
     */
    private Integer confStatus;

    /**
     * 宝箱开启条件，邀请人数
     */
    private Integer openCondition;

    /**
     * 宝箱最大开启次数
     */
    private Integer openNum;

    /**
     * 宝箱关联redis列表
     */
    private List<? extends TreasureRelatedRedisDto> relatedRedisDtoList;

}
