package cn.com.duiba.live.conf.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.conf.BackgroundMusicDto;

import java.util.List;

/**
 * 背景音乐
 * @author lizhi
 * @date 2020/6/28 5:43 PM
 */
@AdvancedFeignClient
public interface RemoteBackgroundMusicApiService {

    /**
     * 查询公司配置的bgm
     * @param companyId 公司ID
     * @return 背景音乐集合
     */
    List<BackgroundMusicDto> findListByCompanyId(Long companyId);

    /**
     * 查询公司配置的bgm
     * @param companyIds 公司ID集合
     * @return 背景音乐集合
     */
    List<BackgroundMusicDto> findListByCompanyIds(List<Long> companyIds);

    /**
     * 批量新增
     * @param list 背景音乐集合
     * @return 执行结果
     */
    int batchInsertGeneratedKeys(List<BackgroundMusicDto> list);

    /**
     * 批量更新
     * @param list 背景音乐集合
     * @return 执行结果
     */
    int batchUpdate(List<BackgroundMusicDto> list);

    /**
     * 批量物理删除
     * @param ids 主键集合
     * @return 执行结果
     */
    int batchDelete(List<Long> ids);
}
