package cn.com.duiba.live.conf.service.api.remoteservice.second.kill;

import cn.com.duiba.live.conf.service.api.dto.second.kill.LiveSecondKillGoodsDto;
import cn.com.duiba.live.conf.service.api.dto.second.kill.LiveSecondKillGoodsSaveDto;
import cn.com.duiba.live.conf.service.api.dto.second.kill.LiveSecondKillGoodsUpdateDto;

import java.util.List;

/**
 * @author guoxuebiao
 * @date 2021/8/10 7:47 下午
 */
public interface RemoteLiveGoodsSecondKillApiService {

    /**
     * 查询直播下的所有秒杀商品列表 redis缓存2min
     * @param liveId 直播id
     * @return 所有秒杀商品列表
     */
    List<LiveSecondKillGoodsDto> findListWithCache(Long liveId);

    /**
     * 查询直播中正在秒杀的商品详情 redis缓存2min
     * @param liveId 直播id
     * @return 商品详情
     */
    LiveSecondKillGoodsDto findUpGoodsDetailByLiveIdCache(Long liveId);

    /**
     * 查询直播下的所有秒杀商品列表
     * @param liveId 直播id
     * @return 所有秒杀商品列表
     */
    List<LiveSecondKillGoodsDto> findList(Long liveId);

    /**
     * 根据秒杀商品id删除
     * @param id 秒杀商品id
     * @return 成功条数
     */
    int deleteById(Long id);

    /**
     * 保存秒杀商品
     * @param dto 秒杀商品实体
     * @return 秒杀商品id
     */
    Long save(LiveSecondKillGoodsSaveDto dto);

    /**
     * 保存秒杀商品
     * @param dto 秒杀商品实体
     * @return 成功条数
     */
    int update(LiveSecondKillGoodsUpdateDto dto);

    /**
     * 上架秒杀商品
     * @param id 秒杀商品id
     * @return 是否成功
     */
    boolean on(Long id);

    /**
     * 下架秒杀商品
     * @param id 秒杀商品id
     * @return 是否成功
     */
    boolean off(Long id);
}
