/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.conf.service.api.enums.potential;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum LiveInviteTypeEnum {
    DIRECT(1, "\u4e00\u5ea6\u4eba\u8109"),
    INDIRECT(2, "\u591a\u5ea6\u4eba\u8109");

    private final Integer type;
    private final String desc;
    private static final Map<Integer, LiveInviteTypeEnum> ENUM_MAP;

    public static List<Integer> allTypes() {
        return Lists.newArrayList(ENUM_MAP.keySet());
    }

    public static LiveInviteTypeEnum getEnum(Integer type) {
        return ENUM_MAP.get(type);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private LiveInviteTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(LiveInviteTypeEnum.values()).collect(Collectors.toMap(LiveInviteTypeEnum::getType, Function.identity())));
    }
}

