package cn.com.duiba.live.conf.service.api.dto.resource;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播资料库
 * @author kjj mybatis generator 
 * @date 2020-04-01
 */
@Data
public class ResourceDto implements Serializable {
     
    private static final long serialVersionUID = 15857122114778642L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播公司ID
     */
    private Long companyId;

    /**
     * 资源标题
     */
    private String resourceTitle;

    /**
     * 资源地址
     */
    private String resourceUrl;

    /**
     * 资料图片
     */
    private String resourceImg;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 资料描述
     */
    private String resourceDesc;

    /**
     * 大图
     */
    private String resourceBigImg;

    /**
     * 资料外部链接
     */
    private String outLink;

    /**
     * 资料外部链接描述
     */
    private String outLinkDesc;

    /**
     * 资料图片，以英文逗号分隔
     */
    private String resourcePictures;

    /**
     * 资料类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveInteractTypeEnum
     */
    private Integer resourceType;

    /**
     * 公众号二维码
     */
    private String oaQrCode;

    /**
     * 外链类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.OutLinkTypeEnum
     */
    private Integer outLinkType;

    /**
     * 外链appId 外链类型为小程序时需要传
     */
    private String outLinkAppId;

    /**
     * 按钮名称
     */
    private String resourceButtonTitle;

    /**
     * 描述
     */
    private String resourceSubTitle;

    /**
     * 表单头图
     */
    private String formBanner;

    /**
     * 贴片地址
     */
    private String pasterUrl;

    /**
     * 测评id
     */
    private Long evaluationId;
}