package cn.com.duiba.live.conf.service.api.remoteservice.mall.attribute;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mall.attribute.MallAttributeValueDto;

import java.util.List;

/**
 * 商城-规格属性value，不允许修改删除操作
 *
 * @author kjj mybatis generator 
 * @date 2022-07-27
 */
@AdvancedFeignClient
public interface RemoteMallAttributeValueService {
     
    /**
     * 根据attributeKey 查询对应属性值集合
     *
     * @param attributeKeyId attributeKey主键
     * @param valueName 属性值名称
     * @return 商城-规格属性value集合
     */
    List<MallAttributeValueDto> listByAttributeKeyId(Long attributeKeyId, String valueName);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 商城-规格属性value
     */
    MallAttributeValueDto selectById(Long id);

    /**
     * 批量根据主键查询
     *
     * @param ids 主键集合
     * @return 商城-规格属性value
     */
    List<MallAttributeValueDto> listByIds(List<Long> ids);

    /**
     * 新增
     *
     * @param dto 商城-规格属性value
     * @return 执行结果
     */
    Long insert(MallAttributeValueDto dto);

}