package cn.com.duiba.live.conf.service.api.remoteservice.mall.checklist;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mall.checklist.MallGoodsChecklistRefDto;

import java.util.List;

/**
 * 商城-商品清单关联表
 *
 * @author kjj mybatis generator 
 * @date 2022-07-27
 */
@AdvancedFeignClient
public interface RemoteMallGoodsChecklistRefService {

    /**
     * 根据商品清单id查询所有
     *
     * @param checklistId 商品清单id
     * @return 商城-商品清单关联集合
     */
    List<MallGoodsChecklistRefDto> listByChecklistId(Long checklistId);

    /**
     * 新增
     *
     * @param dto 商城-商品清单关联
     * @return 执行结果
     */
    boolean insert(MallGoodsChecklistRefDto dto);

    /**
     * 批量插入
     *
     * @param checklistRefList 清单参考列表
     */
    void batchInsert(List<MallGoodsChecklistRefDto> checklistRefList);

    /**
     * 根据商品清单id+商品id 删除
     *
     * @param checklistId 主键
     * @param goodsId 主键
     * @return 执行结果
     */
    boolean delete(Long checklistId, Long goodsId);

    /**
     * 根据清单id批量查询清单列表
     *
     * @param checklistIds 商品清单id
     * @return 商城-商品清单关联集合
     */
    List<MallGoodsChecklistRefDto> listByChecklistIds(List<Long> checklistIds);

    /**
     * 根据商品id查询所有
     *
     * @param goodsId 商品清单id
     * @return 商城-商品清单关联集合
     */
    List<MallGoodsChecklistRefDto> listByGoodsId(Long goodsId);
}