package cn.com.duiba.live.conf.service.api.remoteservice.mall.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mall.goods.MallGoodsDto;
import cn.com.duiba.live.conf.service.api.param.mall.goods.MallGoodsPageParam;

import java.util.List;

/**
 * 商城-商品库
 *
 * @author kjj mybatis generator 
 * @date 2022-07-27
 */
@AdvancedFeignClient
public interface RemoteMallGoodsService {
     
    /**
     * 根据条件分页查询
     *
     * @param param 查询条件
     * @return 商城-商品库集合
     */
    List<MallGoodsDto> pageList(MallGoodsPageParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long pageCount(MallGoodsPageParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 商城-商品库
     */
    MallGoodsDto selectById(Long id);

    /**
     * 新增
     * @param dto 商城-商品库
     * @return 执行结果
     */
    Long insert(MallGoodsDto dto);

    /**
     * 更新
     * @param dto 商城-商品库
     * @return 执行结果
     */
    boolean update(MallGoodsDto dto);

    /**
     * 软删
     *
     * @param id 主键
     * @return 执行结果
     */
    boolean delete(Long id);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键
     * @return 商城-商品库
     */
    List<MallGoodsDto> selectByIds(List<Long> ids);

}