package cn.com.duiba.live.conf.service.api.dto.mall.salegoods;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 商城-商品详情
 *
 * @author xuzhigang
 * @date 2022/8/9 5:27 下午
 **/
@Data
public class MallGoodsDetailDto implements Serializable {
    private static final long serialVersionUID = 7482230083247323842L;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 供应商id，tb_supplier.id
     */
    private Long supplierId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品类型
     */
    private Integer goodsType;

    /**
     * 商品主图列表
     */
    private List<String> mainImgUrls;

    /**
     * 售价
     */
    private Integer discountedPrice;

    /**
     * 市场价
     */
    private Integer marketPrice;

    /**
     * 主标签
     */
    private String mainTag;

    /**
     * 副标签
     */
    private String subTag;

    /**
     * 最大购买数量
     */
    private Integer maxBuyNum;

    /**
     * 发货地址
     */
    private String deliveryPlace;

    /**
     * 发货物流
     */
    private String expressCompany;

    /**
     * 限制购买区域名称
     */
    private String limitRegionName;

    /**
     * 限制购买区域编码
     */
    private String limitRegionCode;

    /**
     * 规格属性列表
     */
    private List<AttributeDto> attributeList;

    /**
     * sku明细列表
     */
    private List<MallSaleSkuDto> skuDetailList;

    /**
     * 买家须知图片
     */
    private String buyerNoticeImgUrl;

    /**
     * 0-未添加到商品库 2-可售 3-待售 4-售罄
     * {@link cn.com.duiba.live.conf.service.api.enums.conf.InteractStatusEnums}
     */
    private Integer status;

}
