package cn.com.duiba.live.conf.service.api.dto.round;

import lombok.Data;

import java.io.Serializable;

/**
 * 时长红包轮次配置表
 * @author kjj mybatis generator 
 * @date 2021-06-10
 */
@Data
public class LiveTimeRedRoundDto implements Serializable {
     
    private static final long serialVersionUID = 16232962937554957L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 需要观看的时间
     */
    private Integer viewTime;

    /**
     * 奖励金额
     */
    private Integer rewardAmount;

    /**
     * 展示金额
     */
    private Integer showAmount;

    /**
     * 是否自动弹出，0-不自动打开，1-自动打开
     * @see cn.com.duiba.live.conf.service.api.enums.common.CommonConfigSwitchEnum
     */
    private Integer autoOpen;

    /**
     * 任务类型：0-未配置，1-关注直播间，2-保存海报, 3-领取权益
     * @see cn.com.duiba.live.conf.service.api.enums.round.TimeRedTaskTypeEnum
     */
    private Integer taskType;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 关联的业务ID
     */
    private Long bizConfId;

}