package cn.com.duiba.live.conf.service.api.enums.treasure;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author zhuenhui
 * @date 2021/04/13 2:23 下午
 * @description 宝箱场景类型枚举
 */
@Getter
@AllArgsConstructor
public enum TreasurePeriodTypeEnum {

    /**
     * 宝箱周期，直播前宝箱业务
     * 可以存在直播前和直播中
     */
    PRE_LIVE(1, "仅直播前"),
    IN_LIVE(2, "仅直播中"),
    THROUGH_LIVE(3, "直播前&直播中"),
    ;

    /**
     * 宝箱类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;
}